/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.IVWWebServiceParamPanel;
import filenet.vw.toolkit.design.property.dialog.VWInvokeAdvancedPanel;
import filenet.vw.toolkit.design.property.dialog.VWInvokeCorrelationSetsPanel;
import filenet.vw.toolkit.design.property.dialog.VWInvokeFaultsPanel;
import filenet.vw.toolkit.design.property.dialog.VWInvokeGeneralPanel;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.ws.api.WSOperation;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;

class VWInvokeParamPanel
extends JTabbedPane
implements IVWWebServiceParamPanel {
    protected static final int TAB_COUNT = 4;
    protected static final int TAB_GENERAL = 0;
    protected static final int TAB_ADVANCED = 1;
    protected static final int TAB_FAULTS = 2;
    protected static final int TAB_CORRELATION_SET = 3;
    private VWInvokeGeneralPanel m_messagePanel = null;
    private VWInvokeAdvancedPanel m_advancedPanel = null;
    private VWInvokeFaultsPanel m_faultsPanel = null;
    private VWInvokeCorrelationSetsPanel m_correlationSetsPanel = null;
    private JDialog m_parentDialog = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInvokeInstruction m_instructionDef = null;

    public VWInvokeParamPanel(JDialog parentDialog) {
        this.m_parentDialog = parentDialog;
    }

    public void init(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.setTabPlacement(1);
        this.m_messagePanel = new VWInvokeGeneralPanel(this.m_parentDialog, (IVWWebServiceParamPanel)this, this.m_authPropertyData, 1);
        this.m_advancedPanel = new VWInvokeAdvancedPanel(this.m_parentDialog, this.m_authPropertyData);
        this.m_faultsPanel = new VWInvokeFaultsPanel(this.m_parentDialog, this.m_authPropertyData);
        this.m_correlationSetsPanel = new VWInvokeCorrelationSetsPanel(this.m_authPropertyData);
        this.addTab(VWResource.s_messageStr, this.m_messagePanel);
        this.addTab(VWResource.s_advanced, this.m_advancedPanel);
        this.addTab(VWResource.s_faults, this.m_faultsPanel);
    }

    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        if (instructionDef != null && instructionDef instanceof VWInvokeInstruction) {
            VWInvokeInstruction invoke = (VWInvokeInstruction)instructionDef;
            if (invoke.equals(this.m_instructionDef)) {
                return;
            }
            this.m_instructionDef = invoke;
            this.m_messagePanel.setInstructionDefinition(this.m_instructionDef);
            this.m_advancedPanel.setInstructionDefinition(this.m_instructionDef);
            this.m_faultsPanel.setInstructionDefinition(this.m_instructionDef);
            this.m_correlationSetsPanel.setInstructionDefinition(this.m_instructionDef);
        }
    }

    public void setOperation(WSOperation operation) {
        if (this.m_faultsPanel != null) {
            this.m_faultsPanel.setOperation(operation);
        }
        if (this.m_correlationSetsPanel != null) {
            this.m_correlationSetsPanel.reinitialize();
        }
    }

    public void switchCSPanelBasicMode() {
        if (this.getTabCount() == 4) {
            this.removeTabAt(3);
        }
    }

    public void switchCSPanelAdvancedMode() {
        if (this.getTabCount() < 4) {
            this.addTab(VWResource.s_correlationSet, this.m_correlationSetsPanel);
        }
    }

    public void reinitializeCorrelationParamList() {
        if (this.m_correlationSetsPanel != null) {
            this.m_correlationSetsPanel.reinitialize();
        }
    }
}

